/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class QuestWrapper {
    public final Quest quest;
    public final Component name;
    public final List<List<ItemStack>> input;
    public final List<List<ItemStack>> output;

    public QuestWrapper(Quest q, List<Reward> rewards) {
        ArrayList<ItemStack> list;
        ItemStack stack;
        Object object;
        this.quest = q;
        this.name = this.quest.getTitle();
        this.input = new ArrayList<List<ItemStack>>(5);
        this.output = new ArrayList<List<ItemStack>>(5);
        if (this.quest.tasks.size() == 1) {
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
        }
        for (Task task : this.quest.tasks) {
            if (task instanceof ItemTask) {
                ItemStack filter = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("itemfilters", "or")));
                this.input.add(Collections.singletonList(filter));
                continue;
            }
            object = task.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.f_41583_;
            if (!stack.m_41619_()) {
                list = new ArrayList<ItemStack>();
                ItemFiltersAPI.getDisplayItemStacks((ItemStack)stack, list);
                this.input.add(list);
                continue;
            }
            if (task.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)task.getIcon()).getStack().m_41777_();
                stack.m_41714_(task.getTitle());
                this.input.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((ItemLike)Items.f_42487_);
            stack.m_41714_(task.getTitle());
            stack.m_41700_("icon", (Tag)StringTag.m_129297_((String)task.getIcon().toString()));
            this.input.add(Collections.singletonList(stack));
        }
        if (rewards.size() == 1) {
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
        }
        for (Reward reward : rewards) {
            object = reward.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.f_41583_;
            if (!stack.m_41619_()) {
                this.output.add(Collections.singletonList(stack.m_41777_()));
                continue;
            }
            if (reward instanceof RandomReward) {
                list = new ArrayList();
                RewardTable table = ((RandomReward)reward).getTable();
                if (table.hideTooltip) {
                    ItemStack unknown = new ItemStack((ItemLike)Items.f_42127_);
                    unknown.m_41714_((Component)new TextComponent("Unknown Reward"));
                    list.add(unknown);
                } else {
                    for (WeightedReward reward1 : table.rewards) {
                        Object object1 = reward1.reward.getIngredient();
                        if (!(object1 instanceof ItemStack)) continue;
                        list.add((ItemStack)object1);
                    }
                }
                this.output.add(list);
                continue;
            }
            if (reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.getIcon()).getStack().m_41777_();
                stack.m_41714_(reward.getTitle());
                this.output.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((ItemLike)Items.f_42487_);
            stack.m_41714_(reward.getTitle());
            stack.m_41700_("icon", (Tag)StringTag.m_129297_((String)reward.getIcon().toString()));
            this.output.add(Collections.singletonList(stack));
        }
    }
}

